package com.digiwin.dap.nest.infrastructure.middleware.redis;

import com.digiwin.dap.nest.kernel.core.config.JaEnvProperty;
import com.digiwin.dap.nest.kernel.core.util.io.serialize.json.DwJson;
import com.digiwin.dap.nest.kernel.core.util.io.serialize.json.adapter.jackson.migration.JacksonAutoType;

import java.lang.reflect.Type;
import java.util.List;

/**
 * redis key 自动添加服务名作为前缀
 *
 * @author chenjian
 * @since 2025年10月28日 17:45:28
 */
public class DwRedisNamespace {

    public static Boolean setString(String key, String value, Long... seconds) {
        return DwRedis.setString(wrapKey(key), value, seconds);
    }

    public static Boolean setNx(String key, String value, Long... seconds) {
        return DwRedis.setNx(wrapKey(key), value, seconds);
    }

    /**
     * 自适应类型, 存储的是json, json中含有type
     */
    public static <T> Boolean setT(String key, T value, Long... seconds) {
        return DwRedis.setT(wrapKey(key), JacksonAutoType.Instance.toString(value), seconds);
    }

    /**
     * 存储的是json, 原生json, 效率高
     */
    public static <T> Boolean setJson(String key, T value, Long... seconds) {
        return DwRedis.setJson(wrapKey(key), DwJson.toString(value), seconds);
    }

    public static String getString(String key) {
        return DwRedis.getString(wrapKey(key));
    }

    /**
     * 存储的是原生json, 需要指定type获取, 效率高
     */
    public static <T> T getByJson(String key, Type type) {
        return DwRedis.getByJson(wrapKey(key), type);
    }

    /**
     * 存储的是含有type的json, 自适应type, 效率低
     */
    public static <T> T getT(String key) {
        return DwRedis.getT(wrapKey(key));
    }

    public static Long del(String key) {
        return DwRedis.del(wrapKey(key));
    }

    public static Boolean exists(String key) {
        return DwRedis.exists(wrapKey(key));
    }

    public static Long expire(String key, Long seconds) {
        return DwRedis.expire(wrapKey(key), seconds);
    }

    public static Long incr(String key, Long... increment) {
        return DwRedis.incr(wrapKey(key), increment);
    }

    public static Long decr(String key, Long... increment) {
        return DwRedis.decr(wrapKey(key), increment);
    }

    public static Object eval(String script, List<String> keys, List<String> args) {
        return DwRedis.eval(script, keys, args);
    }

    /**
     * LIFO, get 0 永远都是最新的
     */
    public static Long lpush(String key, String... args) {
        return DwRedis.lpush(wrapKey(key), args);
    }

    /**
     * FIFO, get 0 不会变
     */
    public static Long rpush(String key, String... args) {
        return DwRedis.rpush(wrapKey(key), args);
    }

    /**
     * @param start 从0开始
     * @param end   -1取所有
     */
    public static List<String> lrange(String key, long start, long end) {
        return DwRedis.lrange(wrapKey(key), start, end);
    }

    /**
     * @param index 从0开始, 精准取list某个值
     */
    public static String lindex(String key, long index) {
        return DwRedis.lindex(wrapKey(key), index);
    }

    /**
     * @param count 大于 0：从头部开始移除最多 count 个匹配的元素。
     *              小于 0：从尾部开始移除最多 count 的绝对值个匹配的元素。
     *              0：移除所有匹配的元素。
     * @param value 移除的元素
     */
    public static Long lrem(String key, long count, String value) {
        return DwRedis.lrem(wrapKey(key), count, value);
    }

    public static String wrapKey(String key) {
        return JaEnvProperty.getApplicationName() + ":" + key;

    }
}
