package com.digiwin.dap.nest.infrastructure.middleware.redis;

import java.util.List;

/**
 * redis api
 *
 * @author chenjian
 * @since 2020年09月10日 17:49:34
 */
public interface JaRedisCommand {

    Boolean set(String key, String value, Long... seconds);

    Boolean setNx(String key, String value, Long... seconds);

    Boolean exists(String key);

    Long del(String key);

    String get(String key);

    /**
     * 设置过期时间
     */
    Long expire(String key, Long seconds);

    /**
     * 自增, 也可以控制增加数
     */
    Long incr(String key, Long... increment);

    /**
     * 自减少, 也可以控制减少数
     */
    Long decr(String key, Long... decrement);

    Object eval(String script, List<String> keys, Object... args);

    /**
     * LIFO, get 0 永远都是最新的
     */
    Long lpush(String key, String... args);

    /**
     * FIFO, get 0 不会变
     */
    Long rpush(String key, String... args);

    /**
     * @param start 从0开始
     * @param end   -1取所有
     */
    List<String> lrange(String key, long start, long end);

    /**
     * @param index 从0开始, 精准取list某个值
     */
    String lindex(String key, long index);

    /**
     * @param count 大于 0：从头部开始移除最多 count 个匹配的元素。
     *              小于 0：从尾部开始移除最多 count 的绝对值个匹配的元素。
     *              0：移除所有匹配的元素。
     * @param value 移除的元素
     */
    Long lrem(String key, long count, String value);

}
