package com.digiwin.dap.nest.infrastructure.middleware.redis.adapter.jedis.command;

import com.digiwin.dap.nest.kernel.core.util.datastructure.JaCollectionUtil;
import com.digiwin.dap.nest.infrastructure.middleware.redis.JaRedisCommand;
import com.digiwin.dap.nest.infrastructure.middleware.redis.adapter.jedis.pool.JedisClusterPool;
import com.digiwin.dap.nest.infrastructure.middleware.redis.meta.JaRedisConstants;
import lombok.SneakyThrows;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 注意高低版本的入参区别
 *
 * @author chenjian
 * @since 2024年04月21日 19:10:31
 */
public class JaJedisClusterCommand implements JaRedisCommand {

    @Override
    public Boolean set(String key, String value, Long... seconds) {
        return JaRedisConstants.OK.equals(JaCollectionUtil.isEmpty(seconds)
                        ? JedisClusterPool.get().set(key, value)
//                : JedisClusterPool.get().setex(key, seconds[0], value)
                        : JedisClusterPool.get().setex(key, seconds[0].intValue(), value)
        );
    }

    @Override
    public Boolean setNx(String key, String value, Long... seconds) {
        return JaRedisConstants.LuaSuccess.equals(JaCollectionUtil.isEmpty(seconds)
                ? JedisClusterPool.get().setnx(key, value)
                : JedisClusterPool.get().eval(JaRedisConstants.LuaSetNxScript, Collections.singletonList(key), Arrays.asList(value, seconds[0].toString()))
        );
    }

    @Override
    public Long del(String key) {
        return JedisClusterPool.get().del(key);
    }

    @Override
    public Boolean exists(String key) {
        return JedisClusterPool.get().exists(key);
    }

    @Override
    @SneakyThrows
    public String get(String key) {
        return JedisClusterPool.get().get(key);
    }

    @Override
    public Long expire(String key, Long seconds) {
//        return JedisClusterPool.get().expire(key, seconds);
        return JedisClusterPool.get().expire(key, seconds.intValue());
    }

    @Override
    public Long incr(String key, Long... increment) {
        if (JaCollectionUtil.isEmpty(increment)) {
            return JedisClusterPool.get().incr(key);
        }
        return JedisClusterPool.get().incrBy(key, increment[0]);
    }

    @Override
    public Long decr(String key, Long... increment) {
        if (JaCollectionUtil.isEmpty(increment)) {
            return JedisClusterPool.get().decr(key);
        }
        return JedisClusterPool.get().decrBy(key, increment[0]);
    }

    @Override
    public Object eval(String script, List<String> keys, Object... args) {
        return JedisClusterPool.get().eval(script, keys, JaCollectionUtil.toStringList(args));
    }

    @Override
    public Long lpush(String key, String... args) {
        if (args == null || args.length == 0) {
            return 0L;
        }
        return JedisClusterPool.get().lpush(key, args);
    }

    @Override
    public Long rpush(String key, String... args) {
        if (args == null || args.length == 0) {
            return 0L;
        }
        return JedisClusterPool.get().rpush(key, args);
    }

    @Override
    public List<String> lrange(String key, long start, long end) {
        return JedisClusterPool.get().lrange(key, start, end);
    }

    @Override
    public String lindex(String key, long index) {
        return JedisClusterPool.get().lindex(key, index);
    }

    @Override
    public Long lrem(String key, long count, String value) {
        return JedisClusterPool.get().lrem(key, count, value);
    }
}
