package com.digiwin.dap.nest.infrastructure.middleware.redis.spring;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;

import java.lang.reflect.Method;

//@Configuration
public class JaRedisConnectionFactory implements BeanPostProcessor {
    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (beanName.equals("redisConnectionFactory")) {
            return getProxy(bean, invocation -> new RedisAdvice().interceptorRedisFactory(invocation));
        }
        return bean;
    }

    public static Object getProxy(Object obj, MethodInterceptor interceptor) {
        ProxyFactory proxy = new ProxyFactory(obj);
        proxy.setProxyTargetClass(true);
        proxy.addAdvice(interceptor);
        return proxy.getProxy();
    }


    public static class RedisAdvice {
        // 如果是getConnection方法，把返回结果进行代理包装
        Object interceptorRedisFactory(MethodInvocation invocation) throws Throwable {
            Object ret = invocation.proceed();
            String methodName = invocation.getMethod().getName();
            if (methodName.equals("getConnection")) {
                return getProxy(ret, this::invoke);
            }
            return ret;
        }

        private Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            String name = method.getName();
            if (name.equals("isPipelined") || name.equals("close"))
                return invocation.proceed();

            Object ret = null;
            try {
                ret = invocation.proceed();
                return ret;
            } catch (Exception exp) {
                throw exp;
            } finally {
            }
        }
    }
}
