/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.redis;

import com.digiwin.dap.nest.infrastructure.middleware.redis.JaRedisCommand;
import com.digiwin.dap.nest.infrastructure.middleware.redis.adapter.jedis.command.JaJedisClusterCommand;
import com.digiwin.dap.nest.infrastructure.middleware.redis.adapter.jedis.command.JaJedisSimpleCommand;
import com.digiwin.dap.nest.infrastructure.middleware.redis.adapter.spring.command.JaRedisTemplateCommand;
import com.digiwin.dap.nest.infrastructure.middleware.redis.config.JaRedisConfig;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaDapperLog;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaLog;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeKind;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeSpan;
import com.digiwin.dap.nest.kernel.core.dapper.meta.RspSpan;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.JaThrowableUtil;
import com.digiwin.dap.nest.kernel.core.util.bytecode.proxy.JaProxyCglib;
import com.digiwin.dap.nest.kernel.core.util.concurrent.JaConcurrentSubmit;
import com.digiwin.dap.nest.kernel.core.util.concurrent.JaConcurrentTasks;
import com.digiwin.dap.nest.kernel.core.util.concurrent.JaThreadLocal;
import com.digiwin.dap.nest.kernel.core.util.datastructure.JaCollectionUtil;
import com.digiwin.dap.nest.kernel.core.util.io.serialize.json.DwJson;
import com.digiwin.dap.nest.kernel.core.util.io.serialize.json.adapter.jackson.migration.JacksonAutoType;
import com.digiwin.dap.nest.kernel.meta.function.JaFunctionP;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.Callable;

public class DwRedis {
    private static final String set = "set";
    private static final JaRedisCommand redisCommand;
    public static final JaThreadLocal<Boolean> SkipSpanThreadLocal;

    private DwRedis() {
    }

    public static <T> void setBigList(String key, List<T> list, int size, Long ... seconds) {
        List lists = JaCollectionUtil.splitBySize(list, (int)size);
        JaConcurrentTasks build = JaConcurrentTasks.build();
        int i = 0;
        while (i < size) {
            int finalI = i++;
            build.add(() -> DwRedis.setJson(key + "-" + finalI, (List)lists.get(finalI), seconds));
        }
        build.add(() -> DwRedis.setT(key + "-size", size, seconds)).get();
    }

    public static <T> List<T> getBigList(String key, Type type) {
        Integer size = (Integer)DwRedis.getT(key + "-size");
        if (null == size) {
            return null;
        }
        JaConcurrentSubmit build = JaConcurrentSubmit.build();
        int i = 0;
        while (i < size) {
            int finalI = i++;
            build.add(() -> DwRedis.getByJson(key + "-" + finalI, type));
        }
        return build.get();
    }

    public static Boolean setString(String key, String value, Long ... seconds) {
        return redisCommand.set(key, value, seconds);
    }

    public static Boolean setNx(String key, String value, Long ... seconds) {
        return redisCommand.setNx(key, value, seconds);
    }

    public static <T> Boolean setT(String key, T value, Long ... seconds) {
        return redisCommand.set(key, JacksonAutoType.Instance.toString(value), seconds);
    }

    public static <T> Boolean setJson(String key, T value, Long ... seconds) {
        return redisCommand.set(key, DwJson.toString(value), seconds);
    }

    public static String getString(String key) {
        return redisCommand.get(key);
    }

    public static <T> T getByJson(String key, Type type) {
        String json = redisCommand.get(key);
        return (T)(DwStringUtil.isEmpty((String)json) ? null : DwJson.toObject((String)json, (Type)type));
    }

    public static <T> T getT(String key) {
        String json = redisCommand.get(key);
        return (T)(DwStringUtil.isEmpty((String)json) ? null : JacksonAutoType.Instance.toObject(json));
    }

    public static Long del(String key) {
        return redisCommand.del(key);
    }

    public static Boolean exists(String key) {
        return redisCommand.exists(key);
    }

    public static Long expire(String key, Long seconds) {
        return redisCommand.expire(key, seconds);
    }

    public static Long incr(String key, Long ... increment) {
        return redisCommand.incr(key, increment);
    }

    public static Long decr(String key, Long ... increment) {
        return redisCommand.decr(key, increment);
    }

    public static Object eval(String script, List<String> keys, List<String> args) {
        return redisCommand.eval(script, keys, args);
    }

    public static Long lpush(String key, String ... args) {
        return redisCommand.lpush(key, args);
    }

    public static Long rpush(String key, String ... args) {
        return redisCommand.rpush(key, args);
    }

    public static List<String> lrange(String key, long start, long end) {
        return redisCommand.lrange(key, start, end);
    }

    public static String lindex(String key, long index) {
        return redisCommand.lindex(key, index);
    }

    public static Long lrem(String key, long count, String value) {
        return redisCommand.lrem(key, count, value);
    }

    public static <T> T cacheT(String key, Callable<T> callable, Long ... seconds) {
        return (T)DwRedis.cache(callable, () -> DwRedis.getT(key), value -> DwRedis.setT(key, value, seconds));
    }

    public static <T> T cacheJson(String key, Callable<T> callable, Type type, Long ... seconds) {
        return (T)DwRedis.cache(callable, () -> DwRedis.getByJson(key, type), value -> DwRedis.setJson(key, value, seconds));
    }

    public static <T> T cache(Callable<T> callable, Callable<T> get, JaFunctionP<T> set) {
        T t;
        try {
            t = get.call();
            if (null != t) {
                return t;
            }
        }
        catch (Throwable e) {
            JaLog.get().error("redis get error", e);
        }
        t = callable.call();
        if (null != t) {
            set.apply(t);
        }
        return t;
    }

    static {
        SkipSpanThreadLocal = new JaThreadLocal();
        try {
            Integer adapter = DwProperty.getInteger((String)"ja.redis.type", (Integer)4);
            if (4 == adapter) {
                redisCommand = new JaRedisTemplateCommand();
            } else {
                Class sourceClz = JaJedisSimpleCommand.class;
                switch (adapter) {
                    case 0: {
                        sourceClz = JaJedisClusterCommand.class;
                        break;
                    }
                    case 3: {
                        sourceClz = JaJedisSimpleCommand.class;
                        break;
                    }
                    default: {
                        JaThrowableUtil.throwRunLog((String)"redis adapter set error:{}", (Object[])new Object[]{adapter});
                    }
                }
                redisCommand = (JaRedisCommand)JaProxyCglib.newInstance(sourceClz, (proxyInstance, method, args, methodProxy, invokeHandler) -> {
                    String methodName = method.getName();
                    boolean skipSpan = null != SkipSpanThreadLocal.get() && (Boolean)SkipSpanThreadLocal.get() != false;
                    RspSpan rspSpan = null;
                    if (!skipSpan) {
                        rspSpan = RspSpan.builder().nodeSpan(NodeSpan.builder().nodeKind(NodeKind.Constant.Redis).nodeId(methodName + " " + String.valueOf(args[0])).build()).build();
                    }
                    try {
                        Object result = invokeHandler.invoke();
                        if (!skipSpan) {
                            rspSpan.setResult(methodName.startsWith(set) ? args : result);
                        }
                        Object object = result;
                        return object;
                    }
                    catch (Throwable e) {
                        if (!skipSpan) {
                            rspSpan.setThrowable(e);
                        } else {
                            JaLog.get().error(methodName + " " + String.valueOf(args[0]), e);
                        }
                        throw e;
                    }
                    finally {
                        if (!skipSpan) {
                            JaDapperLog.response(rspSpan);
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            JaLog.get().error("create redis error : {}", (Object)DwJson.toString((Object)JaRedisConfig.load()), (Object)e);
            throw e;
        }
    }
}

