package com.digiwin.dap.nest.infrastructure.middleware.redis.adapter.redisson;

import com.digiwin.dap.nest.kernel.core.util.concurrent.JaThreadPool;
import com.digiwin.dap.nest.kernel.meta.dto.DwPageReqDTO;
import com.digiwin.dap.nest.kernel.meta.dto.DwResultDTO;
import com.digiwin.dap.nest.infrastructure.middleware.redis.adapter.jedis.JaJedisPoolConfig;
import com.digiwin.dap.nest.infrastructure.middleware.redis.config.JaRedisConfig;
import com.digiwin.dap.nest.infrastructure.middleware.redis.config.JaRedisPoolConfig;
import com.digiwin.dap.nest.infrastructure.middleware.redis.config.JaRedisSimpleConfig;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.redisson.Redisson;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.io.IOException;

/**
 * 不会自动拼接应用名, 会重复, 用来共有
 *
 * @author chenjian
 * @since 2020年09月03日 10:38:17
 */
public class JaRedissonSimpleAdapter {
    public static void main(String[] args) throws IOException, InterruptedException {
        String key = "";
        DwPageReqDTO jaPageReqDTO = new DwPageReqDTO();
        DwResultDTO<DwPageReqDTO> jaPageReqDTOJaResultDTO = new DwResultDTO<>(jaPageReqDTO);

        JaRedisConfig config = JaRedisConfig.load();
        config.setPassword("kael");
        JaRedisPoolConfig pool = config.getPool();
        JaRedisSimpleConfig simple = new JaRedisSimpleConfig();
        config.setSimple(simple);
        simple.setHost("192.168.4.143");
        simple.setPort(6379);

        GenericObjectPoolConfig<Jedis> poolConfig = JaJedisPoolConfig.create(pool);

        JedisPool jedisPool = new JedisPool(poolConfig
                , simple.getHost()
                , simple.getPort()
                , config.getConnectionTimeout()
                , config.getSoTimeout()
                , config.getUser()
                , config.getPassword()
                , simple.getDatabase()
                , simple.getClientName()
        );

        System.out.println(jedisPool.getResource().get("demo"));


        RedissonClient redisson = createRedissonClient();
        for (int i = 0; i < 100; i++) {
            JaThreadPool.execute(() -> {
                long start = System.currentTimeMillis();
                // 存储对象
                RBucket<DwResultDTO<DwPageReqDTO>> demo = redisson.getBucket("demo");
                demo.set(jaPageReqDTOJaResultDTO);
                System.out.println(System.currentTimeMillis() - start);
            });
            JaThreadPool.execute(() -> {
                long start = System.currentTimeMillis();
                RBucket<String> demo = redisson.getBucket("demo");
                System.out.println("String:" + demo.get());
                System.out.println(System.currentTimeMillis() - start);
            });
        }


    }

    private static RedissonClient createRedissonClient() {
        Config config = new Config();

        // 配置单机Redis连接
        config.useSingleServer()
                .setAddress("redis://192.168.4.143:6379")  // Redis地址
                .setPassword("kael")  // 如果有密码就设置，没有就设为null
                .setDatabase(0)     // 选择数据库，默认为0
                .setConnectionPoolSize(10)  // 连接池大小
                .setConnectionMinimumIdleSize(5);  // 最小空闲连接数

        return Redisson.create(config);
    }
}
