/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.redis;

import com.digiwin.dap.nest.infrastructure.middleware.redis.DwRedis;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaLog;
import com.digiwin.dap.nest.kernel.core.lock.distributed.JaDistributedLockAdapter;
import com.digiwin.dap.nest.kernel.core.lock.distributed.JaDistributedLockEntity;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.JaValidateUtil;
import com.digiwin.dap.nest.kernel.core.util.algorithm.id.JaUUID;
import com.digiwin.dap.nest.kernel.meta.adapter.JaI18nAdapter;
import com.digiwin.dap.nest.kernel.meta.function.JaFunctionTR;
import java.util.Set;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JaRedisLock {
    private JaRedisLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T lock(JaDistributedLockEntity entity, JaFunctionTR<T> callable) {
        String lockKey = entity.getLockKey();
        String apiName = entity.getApiName();
        if (DwStringUtil.isEmpty((String)lockKey)) {
            JaLog.get().warn("lockKey is null,{}", (Object)apiName);
            return (T)callable.apply();
        }
        Set reentrantLockKeySet = (Set)JaDistributedLockAdapter.getReentrantThreadLocal().getNotNull();
        if (reentrantLockKeySet.contains(lockKey)) {
            return (T)callable.apply();
        }
        JaLog.biz((String)"lockKey:{}", (Object[])new Object[]{lockKey});
        String requestId = lockKey + ":" + JaUUID.UUID19();
        boolean lock = JaDistributedLockAdapter.spin((JaDistributedLockEntity)entity, () -> DwRedis.setNx(lockKey, requestId, entity.getTimeout()));
        JaValidateUtil.isTrue((!lock ? 1 : 0) != 0, () -> JaI18nAdapter.getMessage((String)entity.getMessage(), (Object[])new Object[0]));
        try {
            reentrantLockKeySet.add(lockKey);
            Object object = callable.apply();
            return (T)object;
        }
        finally {
            JaRedisLock.unlock(lockKey, requestId, entity.isTx());
        }
    }

    private static void unlock(final String lockKey, final String requestId, boolean tx) {
        if (TransactionSynchronizationManager.isSynchronizationActive() && tx) {
            try {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                    public void afterCompletion(int status) {
                        JaRedisLock.unlock(lockKey, requestId);
                    }
                });
            }
            catch (Throwable e) {
                JaLog.get().error("Transaction afterCompletion unLock lock failed", e);
                JaRedisLock.unlock(lockKey, requestId);
            }
        } else {
            JaRedisLock.unlock(lockKey, requestId);
        }
    }

    private static void unlock(String lockKey, String requestId) {
        try {
            String currentValue = DwRedis.getString(lockKey);
            if (!requestId.equals(currentValue)) {
                JaLog.get().warn("redis unlock warn {}:[currentValue:{}, requestId:{}", new Object[]{lockKey, currentValue, requestId});
            }
            if (DwRedis.del(lockKey) < 1L) {
                JaLog.get().error("redis unlock fail:{}", (Object)lockKey);
            }
        }
        catch (Throwable e) {
            JaLog.get().error("redis unlock error:{}", (Object)lockKey);
        }
        finally {
            ((Set)JaDistributedLockAdapter.getReentrantThreadLocal().get()).remove(lockKey);
        }
    }
}

