package com.digiwin.dap.nest.infrastructure.middleware.redis.adapter.lettuce.pool;

import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisAdvancedClusterCommands;

import java.time.Duration;

public class LettuceClusterPool {
    public static void main(String[] args) {
        System.out.println(Duration.ofHours(1).getSeconds());
        // Syntax: rediss://[password@]host[:port]
//        RedisURI redisURI = RedisURI.create("redis://YOTUVDuTMxNpneNA@10.3.205.57:9736");
        RedisURI redisURI = RedisURI.create("redis://vRifkkj2nzS03ajx@gcss-gcsm-redis-zx-uat2.cn-s01-dg01-ituat.redis.oppo.test:6379");
        redisURI.setVerifyPeer(false); // depending on your setup, you might want to disable peer verification

        RedisClusterClient redisClient = RedisClusterClient.create(redisURI);
        StatefulRedisClusterConnection<String, String> connection = redisClient.connect();

        RedisAdvancedClusterAsyncCommands<String, String> async = connection.async();
        RedisAdvancedClusterCommands<String, String> sync = connection.sync();

        System.out.println(sync.get("demo"));


        sync.set("demo", "demo");
        long start = System.currentTimeMillis();
        String set = sync.set("demo", "demo");
        System.out.println(System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        String demo = sync.get("demo");
        System.out.println(System.currentTimeMillis() - start);

        start = System.currentTimeMillis();
        sync.get("demo");
        System.out.println(System.currentTimeMillis() - start);

        start = System.currentTimeMillis();
        sync.del("demo");
        System.out.println(System.currentTimeMillis() - start);
        connection.close();
        redisClient.shutdown();
    }

}
