package com.digiwin.dap.nest.infrastructure.middleware.redis.spring;

import com.digiwin.dap.nest.kernel.core.config.DwConfig;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaAspectOrder;
import com.digiwin.dap.nest.kernel.core.lock.distributed.DwDistributedLock;
import com.digiwin.dap.nest.kernel.core.lock.distributed.DwDistributedLockAdapter;
import com.digiwin.dap.nest.kernel.core.lock.distributed.DwDistributedLockAspect;
import com.digiwin.dap.nest.infrastructure.middleware.redis.DwRedisLock;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@Configuration
public class JaRedisLockAdvisorRegistrar implements BeanFactoryPostProcessor {
    @Override
    public void postProcessBeanFactory(@Nullable ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (Boolean.TRUE.equals(DwConfig.getBoolean("redis.lock.enabled", false))) {
            DefaultListableBeanFactory registry = (DefaultListableBeanFactory) beanFactory;
            AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
            advisor.setExpression("@annotation(" + DwDistributedLock.class.getName() + ")");
            advisor.setOrder(JaAspectOrder.Lock);
            advisor.setAdvice(new DwDistributedLockAspect());
            assert registry != null;
            registry.registerSingleton("jaDistributedLockAspect", advisor);
            DwDistributedLockAdapter.setLockHandler(DwRedisLock::lock);
        }

    }
}
