/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.redis.spring;

import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class JaRedisConnectionFactory
implements BeanPostProcessor {
    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (beanName.equals("redisConnectionFactory")) {
            return JaRedisConnectionFactory.getProxy(bean, invocation -> new RedisAdvice().interceptorRedisFactory(invocation));
        }
        return bean;
    }

    public static Object getProxy(Object obj, MethodInterceptor interceptor) {
        ProxyFactory proxy = new ProxyFactory(obj);
        proxy.setProxyTargetClass(true);
        proxy.addAdvice((Advice)interceptor);
        return proxy.getProxy();
    }

    public static class RedisAdvice {
        Object interceptorRedisFactory(MethodInvocation invocation) throws Throwable {
            Object ret = invocation.proceed();
            String methodName = invocation.getMethod().getName();
            if (methodName.equals("getConnection")) {
                return JaRedisConnectionFactory.getProxy(ret, this::invoke);
            }
            return ret;
        }

        private Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            String name = method.getName();
            if (name.equals("isPipelined") || name.equals("close")) {
                return invocation.proceed();
            }
            Object ret = null;
            Object object = ret = invocation.proceed();
            return object;
        }
    }
}

