package com.digiwin.dap.nest.infrastructure.middleware.redis;

import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.datastructure.JaCache;
import lombok.SneakyThrows;

import java.util.concurrent.Callable;

/**
 * 优先使用物理内存, 全局失效使用redis标示
 *
 * @author chenjian
 * @since 2023年08月30日 17:31:38
 */
public class DwRedisRAM {
    /**
     * 全局失效缓存标示, 不做业务使用, 只用作是否失效
     */
    private static final String flag = "ram";

    @SneakyThrows
    public static <T> T cache(String key, long seconds, Callable<T> callable) {
        T t = get(key);
        if (null == t) {
            t = callable.call();
            set(key, t, seconds);
        }
        return t;
    }

    public static <T> T get(String key) {
        if (DwStringUtil.isEmpty(DwRedis.getString(key))) {
            JaCache.delete(key);
            return null;
        }
        return JaCache.get(key);
    }

    public static <T> T set(String key, T t, long seconds) {
        DwRedis.setString(key, flag, seconds);
        JaCache.set(key, t, seconds);
        return t;
    }

    public static void delete(String key) {
        DwRedis.del(key);
        JaCache.delete(key);
    }
}
