package com.digiwin.dap.nest.infrastructure.middleware.redis.adapter.jedis;

import com.digiwin.dap.nest.kernel.meta.function.JaFunctionP;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

import java.util.List;


/**
 * 注意高低版本jedis包路径变化
 * import redis.clients.jedis.ScanParams;
 * import redis.clients.jedis.ScanResult;
 *
 * @author chenjian
 * @since 2024年04月21日 19:06:11
 */
public class JaJedisScan {

    private JaJedisScan() {
    }

    public static void scan(Jedis jedis, String pattern, Integer count, JaFunctionP<List<String>> jaFunctionD) {
        // 游标初始值为0
        String cursor = "0";
        ScanParams scanParams = new ScanParams();
        scanParams.match(pattern);// 匹配以 PLFX-ZZSFP-* 为前缀的 key
        scanParams.count(count);
        do {
            //使用scan命令获取数据，使用cursor游标记录位置，下次循环使用
            ScanResult<String> scanResult = jedis.scan(cursor, scanParams);
            cursor = scanResult.getCursor();// 返回0 说明遍历完成
            List<String> list = scanResult.getResult();
            jaFunctionD.apply(list);
        } while (!"0".equals(cursor));
    }
}
