package com.digiwin.dap.nest.infrastructure.middleware.redis.adapter.jedis.command;

import com.digiwin.dap.nest.kernel.core.util.datastructure.DwCollectionUtil;
import com.digiwin.dap.nest.infrastructure.middleware.redis.DwRedisCommand;
import com.digiwin.dap.nest.infrastructure.middleware.redis.adapter.jedis.pool.JedisSimplePool;
import com.digiwin.dap.nest.infrastructure.middleware.redis.meta.JaRedisConstants;
import redis.clients.jedis.Jedis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class JaJedisSimpleCommand implements DwRedisCommand {
    @Override
    public Boolean set(String key, String value, Long... seconds) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return JaRedisConstants.OK.equals(DwCollectionUtil.isEmpty(seconds)
                    ? jedis.set(key, value)
                    : jedis.setex(key, seconds[0].intValue(), value)
            );
        }
    }

    @Override
    public Boolean setNx(String key, String value, Long... seconds) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return JaRedisConstants.LuaSuccess.equals(DwCollectionUtil.isEmpty(seconds)
                    ? jedis.setnx(key, value)
                    : jedis.eval(JaRedisConstants.LuaSetNxScript, Collections.singletonList(key), Arrays.asList(value, seconds[0].toString()))
            );
        }
    }

    @Override
    public Boolean exists(String key) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return jedis.exists(key);
        }
    }

    @Override
    public Long del(String key) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return jedis.del(key);
        }
    }

    @Override
    public String get(String key) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return jedis.get(key);
        }
    }

    @Override
    public Long expire(String key, Long seconds) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return jedis.expire(key, seconds.intValue());
        }
    }

    @Override
    public Long incr(String key, Long... increment) {
        try (Jedis jedis = JedisSimplePool.get()) {
            if (DwCollectionUtil.isEmpty(increment)) {
                return jedis.incr(key);
            }
            return jedis.incrBy(key, increment[0]);
        }

    }

    @Override
    public Long decr(String key, Long... increment) {
        try (Jedis jedis = JedisSimplePool.get()) {
            if (DwCollectionUtil.isEmpty(increment)) {
                return jedis.decr(key);
            }
            return jedis.decrBy(key, increment[0]);
        }

    }

    @Override
    public Object eval(String script, List<String> keys, Object... args) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return jedis.eval(script, keys, DwCollectionUtil.toStringList(args));
        }

    }

    @Override
    public Long lpush(String key, String... args) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return jedis.lpush(key, args);
        }
    }

    @Override
    public Long rpush(String key, String... args) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return jedis.rpush(key, args);
        }
    }

    @Override
    public List<String> lrange(String key, long start, long end) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return jedis.lrange(key, start, end);
        }
    }

    @Override
    public String lindex(String key, long index) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return jedis.lindex(key, index);
        }
    }

    @Override
    public Long lrem(String key, long count, String value) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return jedis.lrem(key, count, value);
        }
    }

}
