package com.digiwin.dap.nest.infrastructure.middleware.redis.adapter.jedis.pool;

import com.digiwin.dap.nest.kernel.core.util.DwShutdownHookUtil;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.infrastructure.middleware.redis.adapter.jedis.JaJedisPoolConfig;
import com.digiwin.dap.nest.infrastructure.middleware.redis.config.JaRedisConfig;
import com.digiwin.dap.nest.infrastructure.middleware.redis.config.JaRedisPoolConfig;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Connection;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

import java.util.HashSet;
import java.util.Set;

/**
 * redis 集群模式
 *
 * @author chenjian
 * @since 2020年06月09日 17:21:04
 */
public class JedisClusterPool {

    private JedisClusterPool() {
    }

    private static final JedisCluster jedisCluster;

    static {
        JaRedisConfig config = JaRedisConfig.load();
        JaRedisPoolConfig pool = config.getPool();
        // 添加集群的服务节点Set集合
        // 添加节点
        String cluster = config.getCluster();
        if (DwStringUtil.isEmpty(cluster)) {
            throw new RuntimeException("redis cluster is null");
        }
        String[] clusterArray = cluster.split(",");
        Set<HostAndPort> hostAndPortsSet = new HashSet<>(clusterArray.length);
        for (String s : clusterArray) {
            if (DwStringUtil.isNotEmpty(s)) {
                String[] hostAndPort = s.split(":");
                hostAndPortsSet.add(new HostAndPort(hostAndPort[0], Integer.parseInt(hostAndPort[1])));
            }
        }

        GenericObjectPoolConfig<Connection> poolConfig = JaJedisPoolConfig.create(pool);

        String password = config.getPassword();
        if (DwStringUtil.isEmpty(password)) {
            jedisCluster = new JedisCluster(hostAndPortsSet, poolConfig);
        } else {
            jedisCluster = new JedisCluster(hostAndPortsSet
                    , config.getConnectionTimeout()
                    , config.getSoTimeout()
                    , config.getMaxAttempts()
                    , password
                    , poolConfig);
        }
        DwShutdownHookUtil.add("JedisCluster", jedisCluster::close);
    }

    /**
     * 获取jedis
     */
    public static JedisCluster get() {
        return jedisCluster;
    }
}
