package com.digiwin.dap.nest.infrastructure.middleware.redis.spring;

import com.digiwin.dap.nest.kernel.core.dapper.DwDapper;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeKind;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeSpan;
import com.digiwin.dap.nest.kernel.core.util.bytecode.aop.JaAopUtil;
import com.digiwin.dap.nest.kernel.core.util.reflect.JaReflectUtil;
import com.digiwin.dap.nest.kernel.core.util.unsafe.JaUnsafe;
import com.digiwin.dap.nest.infrastructure.spring.util.DwSpringAopUtil;
import lombok.SneakyThrows;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Configuration;

/**
 * 临时方案, RedisTemplate节点简易处理
 *
 * @author chenjian
 * @since 2024年04月24日 13:55:42
 */
@Configuration
public class JaNodeSpanRedisTemplate implements BeanPostProcessor {

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean.getClass().getName().startsWith("org.springframework.data.redis.core.RedisTemplate")
                || bean.getClass().getName().startsWith("org.springframework.data.redis.core.StringRedisTemplate")
        ) {
            JaRedisTemplateMethodInterceptor methodInterceptor = new JaRedisTemplateMethodInterceptor();
            proxy(bean, methodInterceptor, "valueOps");
            proxy(bean, methodInterceptor, "listOps");
            proxy(bean, methodInterceptor, "streamOps");
            proxy(bean, methodInterceptor, "zSetOps");
            proxy(bean, methodInterceptor, "geoOps");
            proxy(bean, methodInterceptor, "hllOps");
            proxy(bean, methodInterceptor, "clusterOps");
        }
        return bean;
    }


    @SneakyThrows
    private void proxy(Object bean, JaRedisTemplateMethodInterceptor methodInterceptor, String opsFieldName) {
        JaUnsafe.setObjectFieldValue(bean, opsFieldName
                , DwSpringAopUtil.getProxy(JaReflectUtil.getFieldValue(DwSpringAopUtil.getSingletonTarget(bean), opsFieldName)
                        , methodInterceptor));
    }

    static class JaRedisTemplateMethodInterceptor implements MethodInterceptor {

        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            NodeSpan nodeSpan = NodeSpan.builder()
                    .nodeId(JaAopUtil.getSimpleName(invocation))
                    .nodeKind(NodeKind.Constant.Redis)
                    .build();
            Object[] reqArgs = invocation.getArguments();
            return DwDapper.dapperAop(nodeSpan, reqArgs, invocation);
        }
    }

}