/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.redis;

import com.digiwin.dap.nest.infrastructure.middleware.redis.DwRedis;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.lock.distributed.DwDistributedLockAdapter;
import com.digiwin.dap.nest.kernel.core.lock.distributed.DwDistributedLockEntity;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.DwValidateUtil;
import com.digiwin.dap.nest.kernel.core.util.algorithm.id.DwUUID;
import com.digiwin.dap.nest.kernel.meta.adapter.JaI18nAdapter;
import com.digiwin.dap.nest.kernel.meta.function.JaFunctionTR;
import java.util.Set;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DwRedisLock {
    private DwRedisLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T lock(DwDistributedLockEntity entity, JaFunctionTR<T> callable) {
        String lockKey = entity.getLockKey();
        String apiName = entity.getApiName();
        if (DwStringUtil.isEmpty((String)lockKey)) {
            DwLog.get().warn("lockKey is null,{}", (Object)apiName);
            return (T)callable.apply();
        }
        Set reentrantLockKeySet = (Set)DwDistributedLockAdapter.getReentrantThreadLocal().getNotNull();
        if (reentrantLockKeySet.contains(lockKey)) {
            return (T)callable.apply();
        }
        DwLog.biz((String)"lockKey:{}", (Object[])new Object[]{lockKey});
        String requestId = lockKey + ":" + DwUUID.UUID19();
        boolean lock = DwDistributedLockAdapter.spin((DwDistributedLockEntity)entity, () -> DwRedis.setNx(lockKey, requestId, entity.getTimeout()));
        DwValidateUtil.isTrue((!lock ? 1 : 0) != 0, () -> JaI18nAdapter.getMessage((String)entity.getMessage(), (Object[])new Object[0]));
        try {
            reentrantLockKeySet.add(lockKey);
            Object object = callable.apply();
            return (T)object;
        }
        finally {
            DwRedisLock.unlock(lockKey, requestId, entity.isTx());
        }
    }

    private static void unlock(final String lockKey, final String requestId, boolean tx) {
        if (TransactionSynchronizationManager.isSynchronizationActive() && tx) {
            try {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                    public void afterCompletion(int status) {
                        DwRedisLock.unlock(lockKey, requestId);
                    }
                });
            }
            catch (Throwable e) {
                DwLog.get().error("Transaction afterCompletion unLock lock failed", e);
                DwRedisLock.unlock(lockKey, requestId);
            }
        } else {
            DwRedisLock.unlock(lockKey, requestId);
        }
    }

    private static void unlock(String lockKey, String requestId) {
        try {
            String currentValue = DwRedis.getString(lockKey);
            if (!requestId.equals(currentValue)) {
                DwLog.get().warn("redis unlock warn {}:[currentValue:{}, requestId:{}", new Object[]{lockKey, currentValue, requestId});
            }
            if (DwRedis.del(lockKey) < 1L) {
                DwLog.get().error("redis unlock fail:{}", (Object)lockKey);
            }
        }
        catch (Throwable e) {
            DwLog.get().error("redis unlock error:{}", (Object)lockKey);
        }
        finally {
            ((Set)DwDistributedLockAdapter.getReentrantThreadLocal().get()).remove(lockKey);
        }
    }
}

