/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.redis.adapter.spring.command;

import com.digiwin.dap.nest.infrastructure.middleware.redis.DwRedisCommand;
import com.digiwin.dap.nest.infrastructure.middleware.redis.adapter.spring.JaRedisTemplateProcessor;
import com.digiwin.dap.nest.infrastructure.middleware.redis.meta.JaRedisConstants;
import com.digiwin.dap.nest.kernel.core.util.datastructure.DwCollectionUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class JaRedisTemplateCommand
implements DwRedisCommand {
    private final RedisTemplate redisTemplate;
    private static final RedisScript<Long> scriptSetNx = new DefaultRedisScript("if redis.call('setnx', KEYS[1], ARGV[1]) == 1 then return redis.call('expire', KEYS[1], ARGV[2]) else return 0 end", Long.class);

    public JaRedisTemplateCommand() {
        this.redisTemplate = JaRedisTemplateProcessor.getRedisTemplate();
    }

    public JaRedisTemplateCommand(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public Boolean set(String key, String value, Long ... seconds) {
        if (DwCollectionUtil.isEmpty((Object[])seconds)) {
            this.redisTemplate.opsForValue().set((Object)key, (Object)value);
        } else {
            this.redisTemplate.opsForValue().set((Object)key, (Object)value, seconds[0].longValue(), TimeUnit.SECONDS);
        }
        return true;
    }

    @Override
    public Boolean setNx(String key, String value, Long ... seconds) {
        if (DwCollectionUtil.isEmpty((Object[])seconds)) {
            return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value);
        }
        return JaRedisConstants.LuaSuccess == this.redisTemplate.execute(scriptSetNx, Collections.singletonList(key), new Object[]{value, seconds[0].toString()});
    }

    @Override
    public Long del(String key) {
        return Boolean.TRUE.equals(this.redisTemplate.delete((Object)key)) ? 1L : 0L;
    }

    @Override
    public Boolean exists(String key) {
        return Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)key));
    }

    @Override
    public String get(String key) {
        Object o = this.redisTemplate.opsForValue().get((Object)key);
        return null == o ? null : o.toString();
    }

    @Override
    public Long expire(String key, Long seconds) {
        return Boolean.TRUE.equals(this.redisTemplate.expire((Object)key, Duration.ofSeconds(seconds))) ? 1L : 0L;
    }

    @Override
    public Long incr(String key, Long ... increment) {
        if (DwCollectionUtil.isEmpty((Object[])increment)) {
            return this.redisTemplate.opsForValue().increment((Object)key);
        }
        return this.redisTemplate.opsForValue().increment((Object)key, increment[0].longValue());
    }

    @Override
    public Long decr(String key, Long ... decrement) {
        if (DwCollectionUtil.isEmpty((Object[])decrement)) {
            return this.redisTemplate.opsForValue().decrement((Object)key);
        }
        return this.redisTemplate.opsForValue().decrement((Object)key, decrement[0].longValue());
    }

    @Override
    public Object eval(String script, List<String> keys, Object ... args) {
        return this.redisTemplate.execute((RedisScript)new DefaultRedisScript(script, Object.class), keys, args);
    }

    @Override
    public Long lpush(String key, String ... args) {
        if (args == null || args.length == 0) {
            return 0L;
        }
        return this.redisTemplate.opsForList().leftPushAll((Object)key, (Object[])args);
    }

    @Override
    public Long rpush(String key, String ... args) {
        if (args == null || args.length == 0) {
            return 0L;
        }
        return this.redisTemplate.opsForList().rightPushAll((Object)key, (Object[])args);
    }

    @Override
    public List<String> lrange(String key, long start, long end) {
        List objects = this.redisTemplate.opsForList().range((Object)key, start, end);
        if (objects == null) {
            return Collections.emptyList();
        }
        return objects.stream().map(obj -> obj != null ? obj.toString() : null).collect(Collectors.toList());
    }

    @Override
    public String lindex(String key, long index) {
        Object value = this.redisTemplate.opsForList().index((Object)key, index);
        return value != null ? value.toString() : null;
    }

    @Override
    public Long lrem(String key, long count, String value) {
        return this.redisTemplate.opsForList().remove((Object)key, count, (Object)value);
    }
}

