/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.middleware.redis.spring;

import com.digiwin.dap.nest.infrastructure.spring.util.DwSpringAopUtil;
import com.digiwin.dap.nest.kernel.core.dapper.DwDapper;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeKind;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeSpan;
import com.digiwin.dap.nest.kernel.core.util.bytecode.aop.JaAopUtil;
import com.digiwin.dap.nest.kernel.core.util.reflect.JaReflectUtil;
import com.digiwin.dap.nest.kernel.core.util.unsafe.JaUnsafe;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JaNodeSpanRedisTemplate
implements BeanPostProcessor {
    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean.getClass().getName().startsWith("org.springframework.data.redis.core.RedisTemplate") || bean.getClass().getName().startsWith("org.springframework.data.redis.core.StringRedisTemplate")) {
            JaRedisTemplateMethodInterceptor methodInterceptor = new JaRedisTemplateMethodInterceptor();
            this.proxy(bean, methodInterceptor, "valueOps");
            this.proxy(bean, methodInterceptor, "listOps");
            this.proxy(bean, methodInterceptor, "streamOps");
            this.proxy(bean, methodInterceptor, "zSetOps");
            this.proxy(bean, methodInterceptor, "geoOps");
            this.proxy(bean, methodInterceptor, "hllOps");
            this.proxy(bean, methodInterceptor, "clusterOps");
        }
        return bean;
    }

    private void proxy(Object bean, JaRedisTemplateMethodInterceptor methodInterceptor, String opsFieldName) {
        JaUnsafe.setObjectFieldValue((Object)bean, (String)opsFieldName, (Object)DwSpringAopUtil.getProxy((Object)JaReflectUtil.getFieldValue((Object)DwSpringAopUtil.getSingletonTarget((Object)bean), (String)opsFieldName), (MethodInterceptor)methodInterceptor));
    }

    static class JaRedisTemplateMethodInterceptor
    implements MethodInterceptor {
        JaRedisTemplateMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            NodeSpan nodeSpan = NodeSpan.builder().nodeId(JaAopUtil.getSimpleName((MethodInvocation)invocation)).nodeKind(NodeKind.Constant.Redis).build();
            Object[] reqArgs = invocation.getArguments();
            return DwDapper.dapperAop((NodeSpan)nodeSpan, (Object[])reqArgs, (MethodInvocation)invocation);
        }
    }
}

