package com.digiwin.dap.nest.infrastructure.spring.boot.webmvc;

import com.digiwin.dap.nest.kernel.core.dapper.log.JaLog;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.JaThrowableUtil;
import com.digiwin.dap.nest.kernel.meta.dto.DwResultDTO;
import com.digiwin.dap.nest.kernel.meta.exception.DwException;
import com.digiwin.dap.nest.kernel.meta.handler.JaResultParseHandler;
import com.digiwin.dap.nest.infrastructure.spring.boot.util.JaSpringI18nUtil;
import com.digiwin.dap.nest.infrastructure.spring.boot.util.JaSpringExecptionUtil;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import java.util.Locale;

//@ControllerAdvice
public abstract class JaResponseBodyAdvice implements ResponseBodyAdvice<Object> {

    public abstract String errorCode();

    public abstract String okCode();

    public abstract HttpStatus errorHttpStatus();

    @Override
    public boolean supports(@Nullable MethodParameter returnType, @Nullable Class<? extends HttpMessageConverter<?>> converterType) {
        boolean isIO = returnType == null
                || returnType.getParameterType() == Resource.class
                || returnType.getParameterType() == InputStreamResource.class
                || returnType.getParameterType() == ResponseEntity.class;
        return !isIO;
    }


    @Nullable
    @Override
    public Object beforeBodyWrite(@Nullable Object body, @Nullable MethodParameter returnType,
                                  @Nullable MediaType selectedContentType, @Nullable Class selectedConverterType,
                                  @Nullable ServerHttpRequest request, @Nullable ServerHttpResponse response) {
        if (body instanceof JaResultParseHandler) {
            return body;
        }
        return new DwResultDTO<>(body).buildCode(okCode());
    }

    @ResponseBody
    @ExceptionHandler(value = Throwable.class)
    public ResponseEntity<Object> defaultErrorHandler(HttpServletRequest req, Throwable e) {
        String path = req.getRequestURL().toString();
        String code = errorCode();
        String codeMsg;
        String codeMsgLog = null;
        if (e instanceof MethodArgumentNotValidException) {
            codeMsg = JaSpringExecptionUtil.executeMethodArgumentNotValidException(path, (MethodArgumentNotValidException) e);
            JaLog.error("{} valid error:{}", path, codeMsg);
        } else {
            Throwable cause = JaThrowableUtil.getCause(e);
            if (cause instanceof DwException) {
                code = ((DwException) cause).getCode();
                codeMsg = ((DwException) cause).getCodeMsg();
                if (DwStringUtil.isNotEmpty(code) && DwStringUtil.isEmpty(codeMsg)) {
                    codeMsg = JaSpringI18nUtil.getMessage(code, ((DwException) cause).getCodeFormatArgs());
                    codeMsgLog = JaSpringI18nUtil.getMessage(code, Locale.CHINA, ((DwException) cause).getCodeFormatArgs());
                }
            } else {
                codeMsg = e.getMessage() != null ? e.getMessage() : e.getClass().getName();
                codeMsgLog = codeMsg;
            }

            JaLog.error("{} error : {}", path, codeMsgLog, e);
        }
        DwResultDTO<Object> resultDTO = new DwResultDTO<>();
        resultDTO.setCode(code);
        resultDTO.setCodeMsg(codeMsg);
        return new ResponseEntity<>(resultDTO, errorHttpStatus());
    }
}
