package com.digiwin.dap.nest.infrastructure.spring.boot.webmvc;

import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.servlet.JaServletFilter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

@Configuration
public class JaWebConfiguration {

    @Bean
    public JaServletFilter jaServletFilter() {
        return new JaServletFilter();
    }


    @Bean
    public FilterRegistrationBean<JaServletFilter> registerJaServletFilter(JaServletFilter jaServletFilter) {
        FilterRegistrationBean<JaServletFilter> registration = new FilterRegistrationBean<>();
        registration.setFilter(jaServletFilter);
        registration.addUrlPatterns("/*");
        registration.setName("jaServletFilter");
        /**
         * TODO 强制指定最高优先级 未完成
         * org.apache.catalina.core.StandardContext#addFilterMapBefore(org.apache.tomcat.util.descriptor.web.FilterMap)
         * org.apache.catalina.core.StandardContext#addFilterMap(org.apache.tomcat.util.descriptor.web.FilterMap)
         * org.apache.catalina.core.ApplicationFilterChain#addFilter(org.apache.catalina.core.ApplicationFilterConfig)
         *
         * org.springframework.web.filter.OncePerRequestFilter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
         * doFilterInternal(httpRequest, httpResponse, filterChain);
         */
        registration.setOrder(Ordered.HIGHEST_PRECEDENCE + 5);
        return registration;
    }
}
