package com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.context.link;

import com.digiwin.dap.nest.kernel.core.context.biz.DwCoreContextEntity;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.context.JaWebContextLink;
import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.util.JaServletUtil;
import jakarta.servlet.http.HttpServletRequest;

import java.util.Map;

/**
 * 服务信息的链路传递
 *
 * @author chenjian
 * @since 2023年04月02日 18:35:00
 */
public class RemoteAddrContextLink implements JaWebContextLink<DwCoreContextEntity> {
    @Override
    public void inherit(HttpServletRequest source, DwCoreContextEntity target) {
        String sIp = source.getHeader(DwCoreContextEntity.HeaderSourceIp);
        if (DwStringUtil.isEmpty(sIp)) {
            sIp = JaServletUtil.getRemoteAddr(source);
        }
        if (DwStringUtil.isNotEmpty(sIp)) {
            target.setSIp(sIp);
        }

        String usIp = source.getHeader(DwCoreContextEntity.HeaderUpstreamServerIP);
        if (DwStringUtil.isEmpty(usIp)) {
            usIp = JaServletUtil.getRemoteAddr(source);
        }
        if (DwStringUtil.isNotEmpty(usIp)) {
            target.setUsIp(usIp);
        }
    }

    @Override
    public void transmit(DwCoreContextEntity source, Map<String, String> target) {
        // Do nothing
    }

}
