package com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.servlet;

import com.digiwin.dap.nest.kernel.core.config.DwConfig;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.config.JaPropertyListener;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;


public class JaServletConfig {

    private JaServletConfig() {
    }

    private static final Set<String> passUrlSet = new HashSet<>();
    private static final String KeyPassUrlSet = DwConfig.KeyPrefix + "servlet.filter.passUrls";

    static {
        JaPropertyListener.addCommonListener(() -> {
            String passUrls = DwProperty.get(KeyPassUrlSet);
            if (DwStringUtil.isSafeNotEmpty(passUrls)) {
                passUrlSet.addAll(Arrays.asList(passUrls.split(",")));
            }
        });
    }

    public static Set<String> getPassUrlSet() {
        return passUrlSet;
    }

    public static boolean isPass(String requestURI) {
        for (String passUrl : passUrlSet) {
            if (requestURI.contains(passUrl)) {
                return true;
            }
        }
        return false;
    }
}
