package com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.servlet;

import com.digiwin.dap.nest.kernel.core.dapper.alarm.JaAlarmWebhook;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaDapperLog;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaLog;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaMDC;
import com.digiwin.dap.nest.kernel.core.util.JaThrowableUtil;
import com.digiwin.dap.nest.kernel.meta.dto.DwResultDTO;
import com.digiwin.dap.nest.kernel.meta.exception.DwException;
import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.context.JaWebContextChain;
import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.dapper.JaDapperWebProcessor;
import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.util.JaServletUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.SneakyThrows;
import org.springframework.http.HttpStatus;

/**
 * controller 前置处理, 以防三方包内置controller未拦截到
 *
 * @author chenjian
 * @since 2024年01月05日 19:35:06
 */
public class JaServletFilter implements Filter {
    public static int ErrorHttpStatus = HttpStatus.INTERNAL_SERVER_ERROR.value();

    @Override
    public void init(FilterConfig filterConfig) {
        JaWebContextChain instance = JaWebContextChain.getInstance();
        JaLog.info("JaServletFilter init:{}", instance);
    }

    @Override
    @SneakyThrows
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) {
        int connNums = JaDapperWebProcessor.Concurrency.incrementAndGet();
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        String requestURI = request.getRequestURI();
        try {
            JaWebContextChain.getInstance().inherit(request);
            JaDapperWebProcessor.dapper(request, response);

            if (JaServletConfig.isPass(requestURI)) {
                chain.doFilter(servletRequest, servletResponse);
                return;
            }
            JaDapperLog.logEntry(requestURI, connNums);
//            JaDapperWebProcessor.checkUpServer(request);

            chain.doFilter(servletRequest, servletResponse);
        } catch (Throwable e) {
            handleException(request, response, e);
        } finally {
//            alarm(connNums);
            JaWebContextChain.getInstance().remove();
            JaDapperWebProcessor.Concurrency.decrementAndGet();
        }
    }

    @Override
    public void destroy() {
        JaAlarmWebhook.ScheduledThreadPoolExecutor.shutdownNow();
        JaLog.info("JaServletFilter destroy");
    }

    protected static void handleException(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        JaLog.get().error("http filter catch ex", e);
        e = JaThrowableUtil.getCause(e);
        String code = null;
        String codeMsg = null;
        // TODO 未做国际化
        if (e instanceof DwException) {
            code = ((DwException) e).getCode();
        }
//        if (JaStringUtil.isEmpty(code)) {
//            codeMsg = JaI18nUtil.getMessage("Unknown Error"
//                    , request.getRequestURI()
//                    , JaMDC.get());
//        }
        codeMsg = String.format("Unknown Error:[%s]-[%s]"
                , request.getRequestURI()
                , JaMDC.get());
        DwResultDTO<Object> result = new DwResultDTO<>();
        result.setCode(code);
        result.setCodeMsg(codeMsg);
        response.setStatus(ErrorHttpStatus);
        JaServletUtil.printResponse(request, response, result);
    }

}
