package com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.dapper;

import com.digiwin.dap.nest.kernel.core.dapper.log.JaMDC;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.SneakyThrows;
import org.springframework.http.HttpHeaders;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;

public class JaDapperWebProcessor {

    private JaDapperWebProcessor() {
    }

    public static final AtomicInteger Concurrency = new AtomicInteger();

    @SneakyThrows
    public static void dapper(HttpServletRequest request, HttpServletResponse response) {
        request.setCharacterEncoding(StandardCharsets.UTF_8.name());
        if (DwStringUtil.isEmpty(response.getHeader(JaMDC.KeyTraceId))) {
            response.setHeader(HttpHeaders.ACCESS_CONTROL_EXPOSE_HEADERS, JaMDC.KeyTraceId);
            response.addHeader(JaMDC.KeyTraceId, JaMDC.get());
        }
    }
}
