/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.servlet;

import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.context.JaWebContextChain;
import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.dapper.JaDapperWebProcessor;
import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.servlet.JaServletConfig;
import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.util.JaServletUtil;
import com.digiwin.dap.nest.kernel.core.dapper.alarm.JaAlarmWebhook;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaDapperLog;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaLog;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaMDC;
import com.digiwin.dap.nest.kernel.core.util.JaThrowableUtil;
import com.digiwin.dap.nest.kernel.meta.dto.DwResultDTO;
import com.digiwin.dap.nest.kernel.meta.exception.DwException;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;

public class JaServletFilter
implements Filter {
    public static int ErrorHttpStatus = HttpStatus.INTERNAL_SERVER_ERROR.value();

    public void init(FilterConfig filterConfig) {
        JaWebContextChain instance = JaWebContextChain.getInstance();
        JaLog.info((String)"JaServletFilter init:{}", (Object[])new Object[]{instance});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) {
        int connNums = JaDapperWebProcessor.Concurrency.incrementAndGet();
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestURI = request.getRequestURI();
        try {
            JaWebContextChain.getInstance().inherit(request);
            JaDapperWebProcessor.dapper(request, response);
            if (JaServletConfig.isPass(requestURI)) {
                chain.doFilter(servletRequest, servletResponse);
                return;
            }
            JaDapperLog.logEntry((String)requestURI, (int)connNums);
            chain.doFilter(servletRequest, servletResponse);
        }
        catch (Throwable e) {
            JaServletFilter.handleException(request, response, e);
        }
        finally {
            JaWebContextChain.getInstance().remove();
            JaDapperWebProcessor.Concurrency.decrementAndGet();
        }
    }

    public void destroy() {
        JaAlarmWebhook.ScheduledThreadPoolExecutor.shutdownNow();
        JaLog.info((String)"JaServletFilter destroy", (Object[])new Object[0]);
    }

    protected static void handleException(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        JaLog.get().error("http filter catch ex", e);
        e = JaThrowableUtil.getCause((Throwable)e);
        String code = null;
        String codeMsg = null;
        if (e instanceof DwException) {
            code = ((DwException)e).getCode();
        }
        codeMsg = String.format("Unknown Error:[%s]-[%s]", request.getRequestURI(), JaMDC.get());
        DwResultDTO result = new DwResultDTO();
        result.setCode(code);
        result.setCodeMsg(codeMsg);
        response.setStatus(ErrorHttpStatus);
        JaServletUtil.printResponse(request, response, result);
    }
}

