/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.util;

import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.util.JaServletUtil;
import com.digiwin.dap.nest.kernel.core.util.concurrent.JaThreadLocal;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class JaSpringServletUtil {
    private static final JaThreadLocal<HttpServletRequest> httpServletRequestThreadLocal = new JaThreadLocal();

    private JaSpringServletUtil() {
    }

    public static HttpServletRequest getHttpServletRequest() {
        HttpServletRequest httpServletRequest = (HttpServletRequest)httpServletRequestThreadLocal.get();
        if (null != httpServletRequest) {
            return httpServletRequest;
        }
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null == requestAttributes) {
            return null;
        }
        Object resolveReference = requestAttributes.resolveReference("request");
        if (null == resolveReference) {
            return null;
        }
        return (HttpServletRequest)resolveReference;
    }

    public static String getHeader(String name) {
        HttpServletRequest httpServletRequest = JaSpringServletUtil.getHttpServletRequest();
        if (null == httpServletRequest) {
            return null;
        }
        return httpServletRequest.getHeader(name);
    }

    public static String getUserAgent() {
        return JaServletUtil.getUserAgent(JaSpringServletUtil.getHttpServletRequest());
    }

    public static JaThreadLocal<HttpServletRequest> getHttpServletRequestThreadLocal() {
        return httpServletRequestThreadLocal;
    }
}

