package com.digiwin.dap.nest.infrastructure.spring.boot.webmvc;

import com.digiwin.dap.nest.kernel.core.config.DwEnvProperty;
import com.digiwin.dap.nest.kernel.core.config.DwPostPropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;

import java.nio.charset.StandardCharsets;

public class DwWebPostPropertyHandler implements DwPostPropertyHandler {


    @Override
    public void addAndCover() {
        if (DwEnvProperty.isLocal()) {
            DwProperty.getPropertyMap().put("springfox.documentation.enabled", true);
            DwProperty.getPropertyMap().put("spring.mvc.pathmatch.matching-strategy", "ant_path_matcher");
        }


        // 配置 Tomcat 能够同时处理的最大连接数。这是服务器允许的总连接数上限，超过此数量的连接请求将被拒绝或进入等待队列。
//        JaProperty.getPropertyMap().putIfAbsent("server.tomcat.max-connections", 10000 );
        DwProperty.getPropertyMap().putIfAbsent("server.servlet.encoding.charset", StandardCharsets.UTF_8.name());
        DwProperty.getPropertyMap().putIfAbsent("server.servlet.encoding.force", true);
        DwProperty.getPropertyMap().putIfAbsent("server.servlet.encoding.enabled", true);
    }

    @Override
    public int order() {
        return 100;
    }
}
