package com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.context;


import com.digiwin.dap.nest.kernel.core.context.DwMapContextChain;
import com.digiwin.dap.nest.kernel.core.context.DwMapTargetContextChain;
import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.util.DwServletUtil;
import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.util.DwSpringServletUtil;
import jakarta.servlet.http.HttpServletRequest;

import java.util.Map;

/**
 * web 链路
 * 注意 : tomcat获取head效率低
 *
 * @author chenjian
 * @see org.apache.tomcat.util.http.MimeHeaders#getValue(java.lang.String)
 * @since 2023年03月10日 11:55:25
 */
@SuppressWarnings({"rawtypes"})
public class DwWebContextChain extends DwMapTargetContextChain<HttpServletRequest, DwWebContextLink> {

    private DwWebContextChain() {
    }

    @Override
    public void inherit(HttpServletRequest s) {
        DwMapContextChain.getInstance().inherit(DwServletUtil.getAllHeaders(s));
        super.inherit(s);
    }

    @Override
    public void removeChain() {
        DwMapContextChain.getInstance().remove();
        DwSpringServletUtil.getHttpServletRequestThreadLocal().remove();
    }

    @Override
    public Map<String, String> transmit() {
        Map<String, String> transmit = DwMapContextChain.getInstance().transmit();
        transmit.putAll(super.transmit());
        return transmit;
    }

    public static DwWebContextChain getInstance() {
        return Instance.instance;
    }

    private static class Instance {
        private static final DwWebContextChain instance = new DwWebContextChain();
    }
}
