package com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.context;

import com.digiwin.dap.nest.kernel.core.context.DwContextLink;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import jakarta.servlet.http.HttpServletRequest;

import java.util.Map;

/**
 * 基于HTTP协议传输的上下文节点
 *
 * @author chenjian
 * @see DwWebContextChain
 * @since 2023年03月09日 16:59:39
 */
public interface DwWebContextLink<C> extends DwContextLink<HttpServletRequest, Map<String, String>, C> {

    /**
     * 添加请求头
     *
     * @param headers 请求头Map
     * @param key     请求头
     * @param value   请求头值
     */
    default void addHeader(Map<String, String> headers, String key, Object value) {
        if (null != value) {
            String s = value.toString();
            if (DwStringUtil.isNotEmpty(s)) {
                headers.put(key, s);
            }
        }
    }
}
