package com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.servlet;

import com.digiwin.dap.nest.kernel.core.dapper.alarm.JaAlarmWebhook;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaDapperLog;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwMDC;
import com.digiwin.dap.nest.kernel.core.util.JaThrowableUtil;
import com.digiwin.dap.nest.kernel.meta.dto.DwResultDTO;
import com.digiwin.dap.nest.kernel.meta.exception.DwException;
import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.context.DwWebContextChain;
import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.dapper.DwDapperWebProcessor;
import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.util.DwServletUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.SneakyThrows;
import org.springframework.http.HttpStatus;

/**
 * controller 前置处理, 以防三方包内置controller未拦截到
 *
 * @author chenjian
 * @since 2024年01月05日 19:35:06
 */
public class DwServletFilter implements Filter {
    public static int ErrorHttpStatus = HttpStatus.INTERNAL_SERVER_ERROR.value();

    @Override
    public void init(FilterConfig filterConfig) {
        DwWebContextChain instance = DwWebContextChain.getInstance();
        DwLog.info("JaServletFilter init:{}", instance);
    }

    @Override
    @SneakyThrows
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) {
        int connNums = DwDapperWebProcessor.Concurrency.incrementAndGet();
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        String requestURI = request.getRequestURI();
        try {
            DwWebContextChain.getInstance().inherit(request);
            DwDapperWebProcessor.dapper(request, response);

            if (DwServletConfig.isPass(requestURI)) {
                chain.doFilter(servletRequest, servletResponse);
                return;
            }
            JaDapperLog.logEntry(requestURI, connNums);
//            JaDapperWebProcessor.checkUpServer(request);

            chain.doFilter(servletRequest, servletResponse);
        } catch (Throwable e) {
            handleException(request, response, e);
        } finally {
//            alarm(connNums);
            DwWebContextChain.getInstance().remove();
            DwDapperWebProcessor.Concurrency.decrementAndGet();
        }
    }

    @Override
    public void destroy() {
        JaAlarmWebhook.ScheduledThreadPoolExecutor.shutdownNow();
        DwLog.info("JaServletFilter destroy");
    }

    protected static void handleException(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        DwLog.get().error("http filter catch ex", e);
        e = JaThrowableUtil.getCause(e);
        String code = null;
        String codeMsg = null;
        // TODO 未做国际化
        if (e instanceof DwException) {
            code = ((DwException) e).getCode();
        }
//        if (JaStringUtil.isEmpty(code)) {
//            codeMsg = JaI18nUtil.getMessage("Unknown Error"
//                    , request.getRequestURI()
//                    , JaMDC.get());
//        }
        codeMsg = String.format("Unknown Error:[%s]-[%s]"
                , request.getRequestURI()
                , DwMDC.get());
        DwResultDTO<Object> result = new DwResultDTO<>();
        result.setCode(code);
        result.setCodeMsg(codeMsg);
        response.setStatus(ErrorHttpStatus);
        DwServletUtil.printResponse(request, response, result);
    }

}
