package com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.util;

import com.digiwin.dap.nest.kernel.core.util.concurrent.DwThreadLocal;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;


public class DwSpringServletUtil {

    private DwSpringServletUtil() {
    }

    private static final DwThreadLocal<HttpServletRequest> httpServletRequestThreadLocal = new DwThreadLocal<>();

    public static HttpServletRequest getHttpServletRequest() {
        HttpServletRequest httpServletRequest = httpServletRequestThreadLocal.get();
        if (null != httpServletRequest) {
            return httpServletRequest;
        }

        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null == requestAttributes) {
            return null;
        }
        Object resolveReference = requestAttributes.resolveReference(RequestAttributes.REFERENCE_REQUEST);
        if (null == resolveReference) {
            return null;
        }
        return (HttpServletRequest) resolveReference;
    }

    public static String getHeader(String name) {
        HttpServletRequest httpServletRequest = getHttpServletRequest();
        if (null == httpServletRequest) {
            return null;
        }
        return httpServletRequest.getHeader(name);
    }


    public static String getUserAgent() {
        return DwServletUtil.getUserAgent(getHttpServletRequest());
    }

    public static DwThreadLocal<HttpServletRequest> getHttpServletRequestThreadLocal() {
        return httpServletRequestThreadLocal;
    }

}
