/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.servlet;

import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.context.DwWebContextChain;
import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.dapper.DwDapperWebProcessor;
import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.servlet.DwServletConfig;
import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.util.DwServletUtil;
import com.digiwin.dap.nest.kernel.core.dapper.alarm.JaAlarmWebhook;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwMDC;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaDapperLog;
import com.digiwin.dap.nest.kernel.core.util.JaThrowableUtil;
import com.digiwin.dap.nest.kernel.meta.dto.DwResultDTO;
import com.digiwin.dap.nest.kernel.meta.exception.DwException;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;

public class DwServletFilter
implements Filter {
    public static int ErrorHttpStatus = HttpStatus.INTERNAL_SERVER_ERROR.value();

    public void init(FilterConfig filterConfig) {
        DwWebContextChain instance = DwWebContextChain.getInstance();
        DwLog.info((String)"JaServletFilter init:{}", (Object[])new Object[]{instance});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) {
        int connNums = DwDapperWebProcessor.Concurrency.incrementAndGet();
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestURI = request.getRequestURI();
        try {
            DwWebContextChain.getInstance().inherit(request);
            DwDapperWebProcessor.dapper(request, response);
            if (DwServletConfig.isPass(requestURI)) {
                chain.doFilter(servletRequest, servletResponse);
                return;
            }
            JaDapperLog.logEntry((String)requestURI, (int)connNums);
            chain.doFilter(servletRequest, servletResponse);
        }
        catch (Throwable e) {
            DwServletFilter.handleException(request, response, e);
        }
        finally {
            DwWebContextChain.getInstance().remove();
            DwDapperWebProcessor.Concurrency.decrementAndGet();
        }
    }

    public void destroy() {
        JaAlarmWebhook.ScheduledThreadPoolExecutor.shutdownNow();
        DwLog.info((String)"JaServletFilter destroy", (Object[])new Object[0]);
    }

    protected static void handleException(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        DwLog.get().error("http filter catch ex", e);
        e = JaThrowableUtil.getCause((Throwable)e);
        String code = null;
        String codeMsg = null;
        if (e instanceof DwException) {
            code = ((DwException)e).getCode();
        }
        codeMsg = String.format("Unknown Error:[%s]-[%s]", request.getRequestURI(), DwMDC.get());
        DwResultDTO result = new DwResultDTO();
        result.setCode(code);
        result.setCodeMsg(codeMsg);
        response.setStatus(ErrorHttpStatus);
        DwServletUtil.printResponse(request, response, result);
    }
}

