/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.util;

import com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.util.DwServletUtil;
import com.digiwin.dap.nest.kernel.core.util.concurrent.DwThreadLocal;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class DwSpringServletUtil {
    private static final DwThreadLocal<HttpServletRequest> httpServletRequestThreadLocal = new DwThreadLocal();

    private DwSpringServletUtil() {
    }

    public static HttpServletRequest getHttpServletRequest() {
        HttpServletRequest httpServletRequest = (HttpServletRequest)httpServletRequestThreadLocal.get();
        if (null != httpServletRequest) {
            return httpServletRequest;
        }
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null == requestAttributes) {
            return null;
        }
        Object resolveReference = requestAttributes.resolveReference("request");
        if (null == resolveReference) {
            return null;
        }
        return (HttpServletRequest)resolveReference;
    }

    public static String getHeader(String name) {
        HttpServletRequest httpServletRequest = DwSpringServletUtil.getHttpServletRequest();
        if (null == httpServletRequest) {
            return null;
        }
        return httpServletRequest.getHeader(name);
    }

    public static String getUserAgent() {
        return DwServletUtil.getUserAgent(DwSpringServletUtil.getHttpServletRequest());
    }

    public static DwThreadLocal<HttpServletRequest> getHttpServletRequestThreadLocal() {
        return httpServletRequestThreadLocal;
    }
}

