/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.spring.boot.webmvc.util;

import com.alibaba.fastjson.JSON;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwMDC;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.io.net.http.meta.JaContentTypeEnum;
import com.digiwin.dap.nest.kernel.core.util.io.serialize.json.DwJson;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class DwServletUtil {
    public static final String MozillaKey = "Mozilla";
    private static final String[] headersToCheck = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED"};

    private DwServletUtil() {
    }

    public static String getContextPath() {
        Object contextPath = DwProperty.get((String)"server.servlet.context-path");
        if (null == contextPath) {
            return "/";
        }
        if (!((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        if (!((String)contextPath).endsWith("/")) {
            contextPath = (String)contextPath + "/";
        }
        return contextPath;
    }

    public static String getPort() {
        return DwProperty.get((String)"server.port");
    }

    public static String getUserAgent(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        return request.getHeader("User-Agent");
    }

    public static void printResponse(HttpServletRequest request, HttpServletResponse response, Object object) {
        ServletOutputStream out = response.getOutputStream();
        response.setContentType(JaContentTypeEnum.Json.getContentType(StandardCharsets.UTF_8));
        try {
            out.write(JSON.toJSONString((Object)object).getBytes());
        }
        catch (Throwable e) {
            out.write(DwJson.toString((Object)String.format("response print error:[%s:%s:%s]", request.getRequestURL(), object.getClass().getSimpleName(), DwMDC.get())).getBytes());
        }
        out.flush();
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String ip = request.getHeader(headersToCheck[0]);
        if (DwStringUtil.isNotEmpty((String)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            int index = ip.indexOf(",");
            return index != -1 ? ip.substring(0, index) : ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (DwStringUtil.isNotEmpty((String)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static Map<String, String> getAllHeaders(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerName);
            headers.put(headerName, headerValue);
        }
        return headers;
    }

    public static boolean isFromWeb(HttpServletRequest request) {
        String header = request.getHeader("X-Forwarded-For");
        if (DwStringUtil.isNotEmpty((String)header)) {
            return true;
        }
        header = request.getHeader("X-Real-IP");
        if (DwStringUtil.isNotEmpty((String)header)) {
            return true;
        }
        header = request.getHeader("User-Agent");
        return header.contains(MozillaKey);
    }
}

