package com.jugg.agile.spring.boot.dapper;

import com.jugg.agile.framework.core.dapper.aspect.JaAspectOrder;
import com.jugg.agile.framework.core.dapper.aspect.JaDapperAspect;
import com.jugg.agile.framework.core.dapper.aspect.JaDapperAspectPointcut;
import com.jugg.agile.framework.core.dapper.aspect.JaNodeSpanResolver;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import lombok.RequiredArgsConstructor;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Configuration
@RequiredArgsConstructor
@ConditionalOnProperty(name = JaDapperPropertyHandler.KeyDapperInit, havingValue = "true")
public class JaDapperConfiguration implements SmartInitializingSingleton {
    private final List<JaNodeSpanResolver> resolverList;
    private final List<JaDapperAspectPointcut> pointcutList;

    @Override
    public void afterSingletonsInstantiated() {
        JaNodeSpanResolver.Container.init(resolverList);
    }

    @Bean
    public AspectJExpressionPointcutAdvisor dapperAspect() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        String pointcut = JaDapperAspectPointcut.Container.get(pointcutList);
        JaLog.info("dapperAspect pointcut : {}", pointcut);
        advisor.setExpression(pointcut);
        advisor.setOrder(JaAspectOrder.Dapper);
        advisor.setAdvice(new JaDapperAspect());
        return advisor;
    }
}
