package com.jugg.agile.spring.boot.core.config;

import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaEnvPropertyHandler;
import com.jugg.agile.framework.core.config.JaPostPropertyHandler;
import com.jugg.agile.framework.core.config.JaPrePropertyHandler;
import com.jugg.agile.framework.core.config.JaPropertyHandler;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.framework.core.config.JaSpringProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.spring.boot.util.JaSpringBootUtil;
import com.jugg.agile.spring.util.JaSpringCloudFix;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

/**
 * org.springframework.boot.context.event.EventPublishingRunListener
 * org.springframework.boot.context.event.EventPublishingRunListener#environmentPrepared(org.springframework.core.env.ConfigurableEnvironment)
 * org.springframework.boot.context.config.ConfigFileApplicationListener#onApplicationEvent(org.springframework.context.ApplicationEvent)
 */
public class JaEnvironmentPostProcessor implements EnvironmentPostProcessor, Ordered {
    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!JaSpringCloudFix.isCloudContainer()) {
            JaSpringBootUtil.setEnvironment(environment);
            JaSpringProperty.setEnvironmentHandler(environment::getProperty);
            // 预加载一次配置, 本地&env
            JaSpringPropertyProcessor.loadLocalConfig(environment);
            JaPropertyHandler.Processor.loadJaPropertyHandler(JaEnvPropertyHandler.class);
            // 预配置, 通常是跟着代码走,
            JaPropertyHandler.Processor.loadJaPropertyHandler(JaPrePropertyHandler.class);
            // 配置中心
            if (JaEnvProperty.useCenter() && !JaEnvProperty.priorityCenter()) {
                JaPropertyHandler.Processor.loadJaPropertyHandler(JaCenterPropertyHandler.class);
            }
            // 用来适配本地是否覆盖云上
            JaSpringPropertyProcessor.loadLocalConfig(environment);
            // 配置中心
            if (JaEnvProperty.useCenter() && JaEnvProperty.priorityCenter()) {
                JaPropertyHandler.Processor.loadJaPropertyHandler(JaCenterPropertyHandler.class);
            }
            // 后置配置
            JaPropertyHandler.Processor.loadJaPropertyHandler(JaPostPropertyHandler.class);

            String env = JaEnvProperty.getEnv();
            if (JaStringUtil.isNotEmpty(env)) {
                environment.setActiveProfiles(env);
            }
            JaSpringPropertyProcessor.setEnvironment(environment, "jaProperties");

            JaPropertyListener.executeCommonListener();
            JaPropertyListener.executeBizListener();

            JaSpringPropertyProcessor.outputFinalConfig(environment);
        }

    }

    @Override
    public int getOrder() {
        return 0;
    }
}