package com.jugg.agile.spring.boot.core;

import com.jugg.agile.framework.core.util.JaSpiUtil;
import com.jugg.agile.framework.core.util.JaStartupHookUtil;
import com.jugg.agile.spring.boot.util.JaSpringBootUtil;
import com.jugg.agile.spring.util.JaSpringCloudFix;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

import java.util.Objects;

/**
 * 注意高低版本spring-boot兼容
 *
 * @author chenjian
 * @since 2024年04月21日 18:59:42
 */
public class JaSpringApplicationRunListener implements SpringApplicationRunListener, Ordered {

    public JaSpringApplicationRunListener(SpringApplication springApplication, String[] args) {
        if (!JaSpringCloudFix.isCloudContainer()) {
            JaSpringBootUtil.setSpringApplication(springApplication);
            JaSpringBootUtil.setArgs(args);
            JaSpiUtil.getCustomBasePackageSet().addAll(Objects.requireNonNull(JaSpringBootUtil.initRootPackageSet()));
            JaStartupHookUtil.start();
//        JaLogback.addFilter(JaLogbackFilter.class);
        }
    }


    public void starting() {
        if (!JaSpringCloudFix.isCloudContainer()) {
        }
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
//    public void environmentPrepared(ConfigurableBootstrapContext , ConfigurableEnvironment environment) {
        if (!JaSpringCloudFix.isCloudContainer()) {
//            JaSpringPropertyProcessor.initJaProperty(environment);

        }
    }

    @Override
    public void contextPrepared(ConfigurableApplicationContext context) {

    }

    @Override
    public void contextLoaded(ConfigurableApplicationContext context) {

    }

    @Override
    public void failed(ConfigurableApplicationContext context, Throwable exception) {
        if (!JaSpringCloudFix.isCloudContainer()) {
        }
    }

    @Override
    public int getOrder() {
        return -10;
    }

}