package com.jugg.agile.spring.boot.core.config;

import com.jugg.agile.framework.core.config.JaPostPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.meta.adapter.JaI18nAdapter;

import java.util.Arrays;
import java.util.Set;

public class JaI18nPostPropertyHandler implements JaPostPropertyHandler {
    @Override
    public void addAndCover() {
        String basenames = JaProperty.get("spring.messages.basename");
        if (JaStringUtil.isEmpty(basenames)) {
            basenames = "messages";
        }
        Set<String> basenameSet = JaI18nAdapter.getBasenameSet();
        basenameSet.addAll(Arrays.asList(basenames.split(",")));

        addAndCover("spring.messages.basename", String.join(",", basenameSet));
        addAndCover("spring.messages.encoding", "UTF-8");
        addAndCover("spring.messages.useCodeAsDefaultMessage", false);
    }
}
