/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.boot.core.context;

import com.jugg.agile.framework.core.context.JaMapContextLink;
import com.jugg.agile.framework.core.context.biz.JaCoreContextEntity;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.spring.boot.util.JaSpringI18nUtil;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.i18n.LocaleContextHolder;

public class JaAcceptLanguageContextLink
implements JaMapContextLink<JaCoreContextEntity> {
    public void inherit(Map<String, String> source, JaCoreContextEntity context) {
        if (null == JaSpringI18nUtil.LocaleThreadLocal.get()) {
            String acceptLanguage = source.get("accept-language");
            if (JaStringUtil.isEmpty((String)acceptLanguage)) {
                acceptLanguage = source.get("Accept-Language");
            }
            if (JaStringUtil.isNotEmpty((String)acceptLanguage)) {
                Locale locale = JaSpringI18nUtil.parseLocales(acceptLanguage);
                JaSpringI18nUtil.LocaleThreadLocal.set((Object)locale);
                LocaleContextHolder.setLocale((Locale)locale);
            }
        }
    }

    public void transmit(JaCoreContextEntity source, Map<String, String> target) {
        Locale locale = (Locale)JaSpringI18nUtil.LocaleThreadLocal.get();
        if (null != locale) {
            this.transmit(target, "accept-language", locale.toLanguageTag());
        }
    }

    public void remove() {
        JaSpringI18nUtil.LocaleThreadLocal.remove();
        LocaleContextHolder.resetLocaleContext();
    }
}

