/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.boot.core.converter;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.ResourceRegionHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;

public class JaHttpConverterProcessor {
    private JaHttpConverterProcessor() {
    }

    public static HttpMessageConverters httpMessageConverters(AbstractHttpMessageConverter<?> httpMessageConverter) {
        ArrayList<Object> messageConverters = new ArrayList<Object>();
        messageConverters.add(new ByteArrayHttpMessageConverter());
        messageConverters.add(new StringHttpMessageConverter(StandardCharsets.UTF_8));
        messageConverters.add(new ResourceHttpMessageConverter(false));
        messageConverters.add(new ResourceRegionHttpMessageConverter());
        messageConverters.add(new SourceHttpMessageConverter());
        messageConverters.add(new AllEncompassingFormHttpMessageConverter());
        httpMessageConverter.setSupportedMediaTypes(JaHttpConverterProcessor.jsonMediaType());
        messageConverters.add(0, httpMessageConverter);
        return new HttpMessageConverters(false, messageConverters);
    }

    public static List<MediaType> jsonMediaType() {
        ArrayList<MediaType> mediaTypeList = new ArrayList<MediaType>();
        mediaTypeList.add(MediaType.APPLICATION_JSON);
        mediaTypeList.add(MediaType.TEXT_PLAIN);
        mediaTypeList.add(MediaType.APPLICATION_OCTET_STREAM);
        mediaTypeList.add(new MediaType("application", "*+json"));
        return mediaTypeList;
    }
}

