/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.boot.util;

import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.spring.util.JaSpringContextUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.core.env.ConfigurableEnvironment;

public class JaSpringBootUtil {
    private static SpringApplication springApplication;
    private static ConfigurableEnvironment environment;
    private static String[] args;
    private static final Set<String> rootPackageSet;

    private JaSpringBootUtil() {
    }

    public static SpringApplication getSpringApplication() {
        return springApplication;
    }

    public static void setSpringApplication(SpringApplication springApplication) {
        JaSpringBootUtil.springApplication = springApplication;
        JaSpringContextUtil.setMainApplicationClass((Class)springApplication.getMainApplicationClass());
    }

    public static String[] getArgs() {
        return args;
    }

    public static void setArgs(String[] args) {
        JaSpringBootUtil.args = args;
    }

    public static ConfigurableEnvironment getEnvironment() {
        return environment;
    }

    public static void setEnvironment(ConfigurableEnvironment environment) {
        JaSpringBootUtil.environment = environment;
    }

    public static Set<String> getRootPackageSet() {
        return rootPackageSet;
    }

    public static Set<String> initRootPackageSet() {
        if (null == springApplication) {
            return rootPackageSet;
        }
        Class mainApplicationClass = springApplication.getMainApplicationClass();
        SpringBootApplication annotation = mainApplicationClass.getAnnotation(SpringBootApplication.class);
        if (null == annotation) {
            return null;
        }
        Object[] scanBasePackageClasses = annotation.scanBasePackageClasses();
        if (JaCollectionUtil.isNotEmpty((Object[])scanBasePackageClasses)) {
            throw new UnsupportedOperationException("getRootPackage scanBasePackageClasses is not empty");
        }
        Object[] scanBasePackages = annotation.scanBasePackages();
        if (JaCollectionUtil.isEmpty((Object[])scanBasePackages)) {
            String name = mainApplicationClass.getName();
            rootPackageSet.add(name.substring(0, name.lastIndexOf(".")));
        } else {
            rootPackageSet.addAll(Arrays.asList(scanBasePackages));
        }
        return rootPackageSet;
    }

    static {
        rootPackageSet = new HashSet<String>();
    }
}

