/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.boot.util;

import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.concurrent.JaThreadLocal;
import com.jugg.agile.framework.meta.adapter.JaI18nAdapter;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import java.util.Locale;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.MessageSourceAccessor;

public class JaSpringI18nUtil {
    public static final String Header = "accept-language";
    public static final String HeaderUp = "Accept-Language";
    private static MessageSourceAccessor accessor;
    public static final Locale DefaultLocale;
    public static final JaThreadLocal<Locale> LocaleThreadLocal;

    private JaSpringI18nUtil() {
    }

    public static void setAccessor(MessageSourceAccessor accessor) {
        JaSpringI18nUtil.accessor = accessor;
    }

    public static MessageSourceAccessor getAccessor() {
        return accessor;
    }

    public static String getMessage(String code, Object ... args) {
        return JaSpringI18nUtil.getMessage(code, (Locale)LocaleThreadLocal.get(), args);
    }

    public static String getMessage(String code, Locale locale, Object ... args) {
        if (null == accessor) {
            JaSpringI18nUtil.initAccessor();
            if (null == accessor) {
                return code;
            }
        }
        if (null == locale) {
            locale = DefaultLocale;
        }
        try {
            return accessor.getMessage(code, args, locale);
        }
        catch (NoSuchMessageException e) {
            return "NoSuch:" + code;
        }
        catch (Throwable e) {
            return "ParseError:" + code;
        }
    }

    private static synchronized void initAccessor() {
        accessor = (MessageSourceAccessor)JaSpringBeanUtil.getBean(MessageSourceAccessor.class);
    }

    public static Locale parseLocales(String acceptLanguage) {
        try {
            if (JaStringUtil.isEmpty((String)acceptLanguage)) {
                return DefaultLocale;
            }
            String[] language = acceptLanguage.split(";")[0].split(",")[0].split("-");
            if (language.length == 2) {
                return new Locale(language[0], language[1]);
            }
            if (language.length == 1) {
                return new Locale(language[0]);
            }
            return DefaultLocale;
        }
        catch (Throwable e) {
            JaLog.error((String)"parseLocales error:{}", (Object[])new Object[]{acceptLanguage, e});
            return DefaultLocale;
        }
    }

    public static String getLanguage() {
        Locale locale = (Locale)LocaleThreadLocal.get();
        return null == locale ? DefaultLocale.toLanguageTag() : locale.toLanguageTag();
    }

    static {
        DefaultLocale = Locale.SIMPLIFIED_CHINESE;
        LocaleThreadLocal = new JaThreadLocal(o -> LocaleContextHolder.setLocale((Locale)((Locale)o)));
    }

    @Configuration
    public static class JaI18nConfiguration {
        public JaI18nConfiguration() {
            JaI18nAdapter.setI18nHandler(JaSpringI18nUtil::getMessage);
            JaI18nAdapter.setLocaleHandler(JaSpringI18nUtil::getLanguage);
        }

        @Configuration
        @ConditionalOnBean(value={MessageSource.class})
        public static class MessageSourceAwareConfiguration
        implements MessageSourceAware {
            public void setMessageSource(MessageSource messageSource) {
                accessor = new MessageSourceAccessor(messageSource);
            }
        }
    }
}

