package com.jugg.agile.spring.boot.util;

import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class JaSpringExecptionUtil {
    private JaSpringExecptionUtil() {
    }

    public static String executeMethodArgumentNotValidException(String apiName, MethodArgumentNotValidException e) {
        List<ObjectError> allErrors = e.getBindingResult().getAllErrors();
        Set<String> set = new HashSet<>();
        allErrors.forEach(objectError -> {
            String defaultMessage = objectError.getDefaultMessage();
            if (JaStringUtil.isNotEmpty(defaultMessage)) {
                if (defaultMessage.startsWith("{")) {
                    defaultMessage = defaultMessage.substring(1, defaultMessage.length() - 1);
                }
                set.add(defaultMessage);
            }
        });
        // 返回给前端
        StringBuilder message = new StringBuilder();
        // 输出日志
        StringBuilder errorLog = new StringBuilder();

        boolean isFirst = true;
        for (String error : set) {
            if (isFirst) {
                isFirst = false;
            } else {
                message.append(",");
                errorLog.append(",");
            }
            message.append(JaSpringI18nUtil.getMessage(error));
            errorLog.append(JaSpringI18nUtil.getMessage(error, Locale.CHINA));
        }
        JaLog.error("[{}]校验异常:{}", apiName, errorLog.toString());
        return message.toString();
    }
}
