/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.spring.boot.dapper;

import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaDapperAspect;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaDapperAspectPointcut;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaNodeSpanResolver;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaLog;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"ja.dapper.init"}, havingValue="true")
public class JaDapperConfiguration
implements SmartInitializingSingleton {
    @Autowired(required=false)
    private List<JaNodeSpanResolver> resolverList;
    @Autowired(required=false)
    private List<JaDapperAspectPointcut> pointcutList;

    public void afterSingletonsInstantiated() {
        JaNodeSpanResolver.Container.init(this.resolverList);
    }

    @Bean
    public AspectJExpressionPointcutAdvisor dapperAspect() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        String pointcut = JaDapperAspectPointcut.Container.get(this.pointcutList);
        JaLog.info((String)"dapperAspect pointcut : {}", (Object[])new Object[]{pointcut});
        advisor.setExpression(pointcut);
        advisor.setOrder(-10);
        advisor.setAdvice((Advice)new JaDapperAspect());
        return advisor;
    }
}

