package com.digiwin.dap.nest.infrastructure.spring.boot.core.converter;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.digiwin.dap.nest.kernel.core.util.DwDateUtil;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.context.annotation.Bean;

public class JaFastJsonHttpMessageConverter {

    @Bean
    public HttpMessageConverters httpMessageConverters() {
        FastJsonHttpMessageConverter httpMessageConverter = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setSerializerFeatures(
                SerializerFeature.WriteMapNullValue,
                SerializerFeature.WriteNullListAsEmpty,
                SerializerFeature.DisableCircularReferenceDetect,
                SerializerFeature.PrettyFormat);
        fastJsonConfig.setDateFormat(DwDateUtil.Pattern_1);
        httpMessageConverter.setFastJsonConfig(fastJsonConfig);
        return JaHttpConverterProcessor.httpMessageConverters(httpMessageConverter);
    }
}
