package com.digiwin.dap.nest.infrastructure.spring.boot.util;

import com.digiwin.dap.nest.kernel.core.util.datastructure.JaCollectionUtil;
import com.digiwin.dap.nest.infrastructure.spring.util.JaSpringContextUtil;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.core.env.ConfigurableEnvironment;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class JaSpringBootUtil {

    private JaSpringBootUtil() {
    }

    private static SpringApplication springApplication;
    private static ConfigurableEnvironment environment;

    /**
     * 启动参数
     */
    private static String[] args;

    public static SpringApplication getSpringApplication() {
        return springApplication;
    }

    public static void setSpringApplication(SpringApplication springApplication) {
        JaSpringBootUtil.springApplication = springApplication;
        JaSpringContextUtil.setMainApplicationClass(springApplication.getMainApplicationClass());
    }

    public static String[] getArgs() {
        return args;
    }

    public static void setArgs(String[] args) {
        JaSpringBootUtil.args = args;
    }

    private static final Set<String> rootPackageSet = new HashSet<>();

    public static ConfigurableEnvironment getEnvironment() {
        return environment;
    }

    public static void setEnvironment(ConfigurableEnvironment environment) {
        JaSpringBootUtil.environment = environment;
    }

    public static Set<String> getRootPackageSet() {
        return rootPackageSet;
    }

    public static Set<String> initRootPackageSet() {
        if (null == springApplication) {
            return rootPackageSet;
        }
        Class<?> mainApplicationClass = springApplication.getMainApplicationClass();
        SpringBootApplication annotation = mainApplicationClass.getAnnotation(SpringBootApplication.class);
        if (null == annotation) {
            return null;
        }
        Class<?>[] scanBasePackageClasses = annotation.scanBasePackageClasses();
        if (JaCollectionUtil.isNotEmpty(scanBasePackageClasses)) {
            throw new UnsupportedOperationException("getRootPackage scanBasePackageClasses is not empty");
        }
        String[] scanBasePackages = annotation.scanBasePackages();
        if (JaCollectionUtil.isEmpty(scanBasePackages)) {
            String name = mainApplicationClass.getName();
            rootPackageSet.add(name.substring(0, name.lastIndexOf(".")));
        } else {
            rootPackageSet.addAll(Arrays.asList(scanBasePackages));
        }
        return rootPackageSet;
    }

}
