/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.spring.boot.core.context;

import com.digiwin.dap.nest.infrastructure.spring.boot.util.JaSpringI18nUtil;
import com.digiwin.dap.nest.kernel.core.context.DwMapContextLink;
import com.digiwin.dap.nest.kernel.core.context.biz.DwCoreContextEntity;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.i18n.LocaleContextHolder;

public class JaAcceptLanguageContextLink
implements DwMapContextLink<DwCoreContextEntity> {
    public void inherit(Map<String, String> source, DwCoreContextEntity context) {
        if (null == JaSpringI18nUtil.LocaleThreadLocal.get()) {
            String acceptLanguage = source.get("accept-language");
            if (DwStringUtil.isEmpty((String)acceptLanguage)) {
                acceptLanguage = source.get("Accept-Language");
            }
            if (DwStringUtil.isNotEmpty((String)acceptLanguage)) {
                Locale locale = JaSpringI18nUtil.parseLocales(acceptLanguage);
                JaSpringI18nUtil.LocaleThreadLocal.set((Object)locale);
                LocaleContextHolder.setLocale((Locale)locale);
            }
        }
    }

    public void transmit(DwCoreContextEntity source, Map<String, String> target) {
        Locale locale = (Locale)JaSpringI18nUtil.LocaleThreadLocal.get();
        if (null != locale) {
            this.transmit(target, "accept-language", locale.toLanguageTag());
        }
    }

    public void remove() {
        JaSpringI18nUtil.LocaleThreadLocal.remove();
        LocaleContextHolder.resetLocaleContext();
    }
}

