package com.digiwin.dap.nest.infrastructure.spring.boot.dapper;

import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaAspectOrder;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaDapperAspect;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaDapperAspectPointcut;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaNodeSpanResolver;
import com.digiwin.dap.nest.kernel.core.dapper.log.JaLog;
import com.digiwin.dap.nest.kernel.core.dapper.meta.DapperConfigKeyConstants;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Configuration
@ConditionalOnProperty(name = DapperConfigKeyConstants.KeyDapperInit, havingValue = "true")
public class JaDapperConfiguration implements SmartInitializingSingleton {
    @Autowired(required = false)
    private List<JaNodeSpanResolver> resolverList;

    @Autowired(required = false)
    private List<JaDapperAspectPointcut> pointcutList;

    @Override
    public void afterSingletonsInstantiated() {
        JaNodeSpanResolver.Container.init(resolverList);
    }

    @Bean
    public AspectJExpressionPointcutAdvisor dapperAspect() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        String pointcut = JaDapperAspectPointcut.Container.get(pointcutList);
        JaLog.info("dapperAspect pointcut : {}", pointcut);
        advisor.setExpression(pointcut);
        advisor.setOrder(JaAspectOrder.Dapper);
        advisor.setAdvice(new JaDapperAspect());
        return advisor;
    }
}
