/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.spring.boot.core.config;

import com.digiwin.dap.nest.infrastructure.spring.boot.core.config.JaSpringPropertyProcessor;
import com.digiwin.dap.nest.infrastructure.spring.boot.util.JaSpringBootUtil;
import com.digiwin.dap.nest.infrastructure.spring.util.JaSpringCloudFix;
import com.digiwin.dap.nest.kernel.core.config.JaCenterPropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.JaEnvProperty;
import com.digiwin.dap.nest.kernel.core.config.JaEnvPropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.JaPostPropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.JaPrePropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.JaPropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.JaPropertyListener;
import com.digiwin.dap.nest.kernel.core.config.JaSpringProperty;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class JaEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!JaSpringCloudFix.isCloudContainer()) {
            JaSpringBootUtil.setEnvironment(environment);
            JaSpringProperty.setEnvironmentHandler(arg_0 -> ((ConfigurableEnvironment)environment).getProperty(arg_0));
            JaSpringPropertyProcessor.loadLocalConfig(environment);
            JaPropertyHandler.Processor.loadJaPropertyHandler(JaEnvPropertyHandler.class);
            JaPropertyHandler.Processor.loadJaPropertyHandler(JaPrePropertyHandler.class);
            if (JaEnvProperty.useCenter() && !JaEnvProperty.priorityCenter()) {
                JaPropertyHandler.Processor.loadJaPropertyHandler(JaCenterPropertyHandler.class);
            }
            JaSpringPropertyProcessor.loadLocalConfig(environment);
            if (JaEnvProperty.useCenter() && JaEnvProperty.priorityCenter()) {
                JaPropertyHandler.Processor.loadJaPropertyHandler(JaCenterPropertyHandler.class);
            }
            JaPropertyHandler.Processor.loadJaPropertyHandler(JaPostPropertyHandler.class);
            String env = JaEnvProperty.getEnv();
            if (DwStringUtil.isNotEmpty((String)env)) {
                environment.setActiveProfiles(new String[]{env});
            }
            JaSpringPropertyProcessor.setEnvironment(environment, "jaProperties");
            JaPropertyListener.executeCommonListener();
            JaPropertyListener.executeBizListener();
            JaSpringPropertyProcessor.outputFinalConfig(environment);
        }
    }

    public int getOrder() {
        return 0;
    }
}

