package com.digiwin.dap.nest.infrastructure.spring.boot.core.config;

import com.digiwin.dap.nest.kernel.core.config.DwPostPropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.meta.adapter.JaI18nAdapter;

import java.util.Arrays;
import java.util.Set;

public class DwI18nPostPropertyHandler implements DwPostPropertyHandler {
    @Override
    public void addAndCover() {
        String basenames = DwProperty.get("spring.messages.basename");
        if (DwStringUtil.isEmpty(basenames)) {
            basenames = "messages";
        }
        Set<String> basenameSet = JaI18nAdapter.getBasenameSet();
        basenameSet.addAll(Arrays.asList(basenames.split(",")));

        addAndCover("spring.messages.basename", String.join(",", basenameSet));
        addAndCover("spring.messages.encoding", "UTF-8");
        addAndCover("spring.messages.useCodeAsDefaultMessage", false);
    }
}
